<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CommandProduct extends Model 
{

    protected $table = 'command_products';
    public $timestamps = true;
    protected $fillable = array('quantity', 'unit', 'unit_price', 'subtotal', 'command_id', 'product_id');
    protected $visible = array('quantity', 'unit', 'unit_price', 'subtotal', 'command_id', 'product_id');

    public function products()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

    public function commands()
    {
        return $this->belongsTo('App\Models\Command', 'command_id');
    }

}